
#ifndef CE2_DES_H
#define CE2_DES_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object % CE2_DES.h    : %
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 16:55:05 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains all of the enums and definitions that are used for the 
   *         CE2 DES APIs, as well as the APIs themselves.
   *
   *  \version CE2_DES.h#1:incl:13
   *  \author Discretix
   *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Defines ******************************/

/** 
@brief - a definition describing the low level Engine type ( SW , Hardware , Etc )
*/

/* The size of the IV or counter buffer */
#define CE2_DES_IV_SIZE_IN_WORDS 2
#define CE2_DES_IV_SIZE_IN_BYTES ( CE2_DES_IV_SIZE_IN_WORDS * sizeof(DxUint32_t) )

/* The maximum number of KEYS supported by DES */
#define CE2_DES_MAX_NUMBER_OF_KEYS 3

/* The key size in words on the DES machine */
#define CE2_DES_KEY_SIZE_IN_WORDS 2
#define CE2_DES_KEY_SIZE_IN_BYTES ( CE2_DES_KEY_SIZE_IN_WORDS * sizeof(DxUint32_t) )

/* The DES block size in bytes */
#define CE2_DES_BLOCK_SIZE_IN_BYTES 8

/* The DES block size in words */
#define CE2_DES_BLOCK_SIZE_IN_WORDS 2

/************************ Enums ********************************/

/* The number of keys supported on the DES machine */
typedef enum
{
   CE2_DES_1_KeyInUse  = 1,
   CE2_DES_2_KeysInUse = 2,
   CE2_DES_3_KeysInUse = 3,
   
   CE2_DES_NumOfKeysOptions
   
}CE2_DES_NumOfKeys_t;

/* Enum definitions for the Encrypt or Decrypt operation mode */
typedef enum 
{
   CE2_DES_Encrypt = 0,
   CE2_DES_Decrypt = 1,
   
   CE2_DES_EncryptNumOfOptions

}CE2_DES_EncryptMode_t;

/* Enum definitions for the DES operation mode */
typedef enum
{
   CE2_DES_ECB_mode = 0,
   CE2_DES_CBC_mode = 1,

   CE2_DES_NumOfModes

}CE2_DES_OperationMode_t;      
   
/************************ Typedefs  ****************************/

/* The IV buffer definition */
typedef DxUint8_t CE2_DES_Iv_t[CE2_DES_IV_SIZE_IN_BYTES];

/* defining the KEY argument - containing 3 keys maximum */
typedef struct CE2_DES_Key_t
{
   /* the key variables */
   DxUint8_t key1[CE2_DES_KEY_SIZE_IN_BYTES]; 
   DxUint8_t key2[CE2_DES_KEY_SIZE_IN_BYTES];
   DxUint8_t key3[CE2_DES_KEY_SIZE_IN_BYTES];

}CE2_DES_Key_t;   

/************************ Structs  ******************************/

/* Defines the KEY argument - contains 3 keys maximum */
typedef struct 
{
   /* the key variables */
   DxUint32_t key1[CE2_DES_KEY_SIZE_IN_WORDS]; 
   DxUint32_t key2[CE2_DES_KEY_SIZE_IN_WORDS];
   DxUint32_t key3[CE2_DES_KEY_SIZE_IN_WORDS];

}CE2_DES_Key_32bit_t;   

/************************ Structs  ******************************/

/************************ Public Variables **********************/


/************************ Public Functions **********************/
/**
****************************************************************
* Function Name: 
*  CE2_DES
*
* Inputs:
* @param IV_ptr [in\out] - This parameter is the buffer of the IV;
* @param Key_ptr [in] - A pointer to the user's key buffer;
* @param NumOfKeys [in] - The number of keys used: 1, 2, or 3 (defined in the enum);
* @param EncryptDecryptFlag [in] - A flag that determines if the DES should perform;
* @param OperationMode [in] - The operation mode: ECB or CBC;
* @param DataIn_ptr [in] - The pointer to the buffer of the input data to the DES;
* @param DataInSize [in] - The size of the input data.
* @param DataOut_ptr [out] - The pointer to the buffer of the output data from the DES;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*   - CE2_DES_INVALID_KEY_PTR_ERROR
*   - CE2_DES_ILLEGAL_NUM_OF_KEYS_ERROR
*   - CE2_DES_ILLEGAL_ENCRYPT_DECRYPT_FLAG_ERROR
*   - CE2_DES_ILLEGAL_HASH_OP_MODE_ERROR
*   - CE2_DES_INVALID_DATA_IN_PTR_ERROR
*   - CE2_DES_INVALID_DATA_IN_SIZE_ERROR
*
* \brief \b
* Description:
*   This function is used to operate the DES machine in one integrated
* operation: an Encrypt or a Decrypt operation, using operation
* mode: ECB or CBC.
*
* \b
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_DES 
*     to operate the DES machine with using LibTomCrypt.
***************************************************************/
 CE2CIMPORT_C CE2Error_t  CE2_DES(CE2_DES_Iv_t            IV_ptr,
                                 CE2_DES_Key_t           *Key_ptr,
                                 CE2_DES_NumOfKeys_t     NumOfKeys,
                                 CE2_DES_EncryptMode_t   EncryptDecryptFlag,
                                 CE2_DES_OperationMode_t OperationMode,             
                                 DxUint8_t                *DataIn_ptr,             /* in */ 
                                 DxUint32_t                DataInSize,              /* in */ 
                                 DxUint8_t                 *DataOut_ptr );          /* in / out */ 

#ifdef __cplusplus
}
#endif

#endif
